global VFB_methods

-------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------
--
-- Top-Left Rollout
--

rollout VFB_Rollout_TopLeft "VFB_Rollout_TopLeft" width:~VFB_ROLLOUT_TOPLEFT_WIDTH~ height:62
(
	----------------------------------------------------------------------------
	-- LOCALIZATION [begin - first string only section]
	-- Translate the FIRST STRING ONLY of each line below
	
	dropdownList RenderTypeDropdown ~RENDERTYPEDROPDOWN_AREA_TO_RENDER_CAPTION~ pos:[4,16] width:~RENDERTYPEDROPDOWN__WIDTH~ height:40
	checkbutton EditRegionBtn "" pos:~EDITREGIONBTN_POSITION~ width:20 height:20 iconName:"RenderFrameWindow/EditRegion" iconSize:[16,16]
	checkbutton AutoRegionSelectedBtn "" pos:~AUTOREGIONSELECTEDBTN_POSITION~ width:20 height:20 iconName:"RenderFrameWindow/AutoRegionSelected" iconSize:[16,16]
	
	button RegionWarningBtn "" pos:~REGIONWARNINGBTN_POSITION~ width:20 height:20 iconName:"RenderFrameWindow/Error" iconSize:[16,16] border:false visible:false

	checkbutton IncludeSubsetPixelsCheck "" pos:~INCLUDESUBSETPIXELSCHECK_POSITION~ width:20 height:20 iconName:"RenderFrameWindow/SubsetPixels" iconSize:[16,16]
	
	dropdownList ViewportDropdown ~VIEWPORTDROPDOWN_CAPTION~ pos:~VIEWPORTDROPDOWN_POSITION~ width:108 height:40
	checkbutton LockToViewportBtn "" pos:~LOCKTOVIEWPORTBTN_POSITION~ width:20 height:20 iconName:"Common/Lock" iconSize:[16,16]
	
	dropdownList RenderPresetDropdown ~RENDERPRESETDROPDOWN_CAPTION~ pos:~RENDERPRESETDROPDOWN_POSITION~ width:~RENDERPRESETDROPDOWN_WIDTH~ height:40
	
	checkbutton RenderDialogBtn "" pos:~RENDERDIALOGBTN_POSITION~ width:20 height:20 iconName:"RenderFrameWindow/RenderSetup" iconSize:[16,16]
	checkbutton EnvironmentDialogBtn "" pos:~ENVIRONMENTDIALOGBTN_POSITION~ width:20 height:20 iconName:"RenderFrameWindow/ExposureControls" iconSize:[16,16]

	-- LOCALIZATION [end - first string only section]
	----------------------------------------------------------------------------


	----------------------------------------------------------------------------
	-- LOCALIZATION [begin - translate everything section]
	-- Translate everything in quotes below
	
	local IncludeSubsetPixelsCheckTooltip =
		~INCLUDESUBSETPIXELSCHECKTOOLTIP~

	
	
	local renderTypeList = undefined
	local renderTypeTableSorted = undefined
	local renderTypeTable =
	#(		-- Render Type Code			-- Dropdown name	--Table Index
			#( #view,					~RENDERTYPETABLE_NAME_VIEW_CAPTION~,				1 ),
			#( #selected,				~RENDERTYPETABLE_SELECTED_CAPTION~,			2 ),
			#( #region,					~RENDERTYPETABLE_REGION_CAPTION~,			3 ),
			#( #crop,					~RENDERTYPETABLE_CROP_CAPTION~,				4 ),
			#( #blowUp,					~RENDERTYPETABLE_BLOWUP_CAPTION~,			5 )
	)
	
	local EditRegionBtnTooltip= ~EDITREGIONBTNTOOLTIP_CAPTION~
	local AutoRegionSelectedBtnTooltip = ~AUTOREGIONSELECTEDBTNTOOLTIP_CAPTION~
	local RegionWarningBtnTooltip_SizeMismatch = \
		~REGION_TOOLS_DISABLED_IMAGE_MAY_NOT_MATCH_FRAMEBUFFER_CAPTION~ +
		~RENDER_TO_RESET_FRAME_BUFFER_ALLOW_ACCURATE_REGION_DISPLAY~
	local RegionWarningBtnTooltip_Crop = \
		~IMAGE_MAY_NOT_MATCH_CURRENT_FRAME_BUFFER~
	local RegionWarningBtnTooltip_Blowup = \
		~IMAGE_MAY_NOT_MATCH_FRAME_BUFFER_EDIT_REGION_BLOWUP~
	local LockToViewportBtnTooltip = ~LOCKTOVIEWPORTBTNTOOLTIP~
	local LoadPresetString = ~LOADPRESETSTRING~
	local SavePresetString = ~SAVEPRESETSTRING~
	local RenderPresetsLoadCaption = ~RENDERPRESETSLOADCAPTION~
	local RenderPresetsSaveCaption = ~RENDERPRESETSSAVECAPTION~
	local RenderPresetsFilespec = ~RENDERPRESETSFILESPEC_CAPTION~
	local RenderDialogActionItemName = ~RENDERDIALOGACTIONITEMNAME_RENDER_SETUP~
	local EnvironmentDialogActionItemName = ~ENVIRONMENTDIALOGACTIONITEMNAME~
	
	-- LOCALIZATION [end - translate everything section]
	----------------------------------------------------------------------------
	
	local renderPresetList
	local maxViewports = 4 -- Assume  4 viewports internally
	local separator = "-----------------------------------------------------------------------------------------------------------------------------------------------------"

	-- Given a string table, returns a flat list of strings, discarding the key values.
	-- A string table is a sorted array of items, where each item is
	-- an array with its key and the string as the first two entries
	function StringTable_to_StringList src =
	(
		local stringList = #()
		for entry in src do append stringList entry[2]
		stringList -- return value
	)
	
	-- A list made of #(key,value) pairs becomes a set of two lists, one with keys and another with values
	-- Thus src[x][y]==dest[y][x], where y is either 1 or 2
	function ListOfPairs_to_PairOfLists src =
	(
		local list1 = #()
		local list2 = #()
		for entry in src do
		(
			append list1 entry[1]
			append list2 entry[2]
		)
		#( list1, list2 ) -- return value
	)

	-- Heler function: Returns true if the render type uses a user-defined region
	function IsUserRegionRenderType renderType:undefined =
	(
		if renderType==undefined do renderType = GetRenderType()
		case renderType of
		(
		#region:	true
		#crop:		true
		#blowUp:	true
		default:	false
		)
	)

	-- Helper function: Returns true if the render type automatically uses a region around the selection
	function IsAutoRegionSelectedRenderType renderType:undefined =
	(
		if renderType==undefined do renderType = GetRenderType()
		case renderType of
		(
		#boxSelected:		true
		#regionSelected:	true
		#cropSelected:		true
		default:			false
		)
	)
	
	-- Helper function: Returns true if the render type uses any user-defined or automatic region
	function IsRegionRenderType renderType:undefined =
	(
		((IsUserRegionRenderType renderType:renderType) or (IsAutoRegionSelectedRenderType renderType:renderType))
	)
	
	function UpdateRegionWarning =
	(
		local warningVisible = false
		local renderType = GetRenderType()
		if renderType==#crop then
		(
			regionWarningBtn.tooltip = RegionWarningBtnTooltip_Crop
			warningVisible = true
		)
		else if renderType==#blowup then
		(
			regionWarningBtn.tooltip = RegionWarningBtnTooltip_Blowup
			warningVisible = true
		)
		else if renderType==#region then
		(
			local b = getLastRenderedImage copy:false
			if ((b.width!=renderWidth) or (b.height!=renderHeight)) do
			(
				regionWarningBtn.tooltip = RegionWarningBtnTooltip_SizeMismatch
				warningVisible = true
			)
			free b 
		)
		regionWarningBtn.visible = warningVisible
	)
	
	-- Helper function: Converts base render types (region/blowup/crop)
	-- to their "selection" equivalents (region selected/box selected/crop selected)
	function BaseRenderType_to_AutoRegionSelected renderType =
	(
		case renderType of
		(
		#blowup:	#boxSelected
		#region:	#regionSelected
		#crop:		#cropSelected
		default:	renderType -- No conversion by default
		)
	)

	-- Helper function: Converts "selection" render types (region selected/box selected/crop selected)
	-- to their base equivalents (region/blowup/crop)
	function AutoRegionSelectedRenderType_to_Base renderType =
	(
		case renderType of
		(
		#boxSelected:		#blowup
		#regionSelected:	#region
		#cropSelected:		#crop
		default:			renderType -- No conversion by default
		)
	)
	
	-- Helper function: Converts a render type either to, or from, a "selection" type
	-- (for example, region to region selected, or region selected to region)
	-- First parameter is the render type
	-- Second parameter is a boolean, true to convert into a "selection" type, false to convert back from a "selection" type
	function ConvertRenderType renderType autoRegionSelected =
	(
		if autoRegionSelected then BaseRenderType_to_AutoRegionSelected renderType
		else AutoRegionSelectedRenderType_to_Base renderType
	)
	
	-- For a given render type, find the appropriate entry index in the RenderTypeDropdown
	function GetRenderTypeDropdownIndex renderType:undefined =
	(
		if renderType==undefined do renderType = GetRenderType()
		renderType = ConvertRenderType renderType false

		local item = VFB_methods.LookupTableLookup renderType renderTypeTableSorted
		if item==undefined then undefined
		else item[3] -- return the index
	)

	----------------------------------------------------------------------------
	-- Viewport Dropdown Functions
	
	-- convert viewID to index of the viewport dropdown list
	function ViewId_to_ViewportDropdownIndex  viewID =
	(
		local retval = -1
		local vptInfo = VFB_methods.viewportInfo
		for i = 1 to vptInfo.totalVptNum_  while (retval == -1) do
		(
			if (vptInfo.entries_[i].viewId_) == viewID do
			(
				retval = vptInfo.entries_[i].index_
			)
		) 
		retval
	)
	
	-- Convert index of viewport dropdown list to viewID
	function ViewportDropdownIndex_to_ViewId  listIndex = 
	(
		local retval = -1
		local vptInfo = VFB_methods.viewportInfo
		for i = 1 to vptInfo.totalVptNum_ while (retval == -1) do
		(
			if (vptInfo.entries_[i].index_) == listIndex do
			(
				retval = vptInfo.entries_[i].viewId_ 
			)
		) 
		retval
	)

	function SetRendViewID newRendViewID =
	(
		if newRendViewID <= 0 do 
		(
			newRendViewID = viewport.activeViewportId
		)
		rendViewID = newRendViewID
	)
	
	-- Update the selection of the viewport dropdownlist.
	function UpdateViewportDropdown =
	(
		local viewLocked = not rendUseActiveView
		LockToViewportBtn.checked = viewLocked
		if viewLocked then
		(
			ViewportDropdown.selection = (ViewId_to_ViewportDropdownIndex rendViewID)
		)
		else
		(
			ViewportDropdown.selection = (ViewId_to_ViewportDropdownIndex viewport.activeViewportId)
		)
		
		EditRenderRegion.UpdateRegion() -- match the displayed region to the dropdown
	)

	-- initialize the viewport dropdown list
	function InitViewportDropdown =
	(
		local viewLocked = not rendUseActiveView
		local viewportNames = #()
		
		-- Store the viewport configuration, to detect configurations in NotifyViewportChange
		-- besides use this structure to quickly convert between dropdownIndex and viewID.
		if (VFB_methods.viewportInfo == undefined) do
		(
			VFB_methods.viewportInfo = VFB_methods.GetViewportInfo()
		)
		local vptInfo = VFB_methods.viewportInfo
		
		for i = 1 to vptInfo.totalVptNum_ do
		(
			local vptName = vptInfo.entries_[i].name_
			append viewportNames (vptName)
		)
		ViewportDropdown.items = viewportNames
		-- this forces the size of the dropped list to be recomputed
		local tempWidth = ViewportDropdown.width
		ViewportDropdown.width = tempWidth
	
		LockToViewportBtn.tooltip = LockToViewportBtnTooltip
		LockToViewportBtn.checked = viewLocked
	)

	function RefreshViewportDropdown =
	(
		InitViewportDropdown()
		UpdateViewportDropdown()
	)



	----------------------------------------------------------------------------
	-- Notify Handlers
	
	-- Install all notification handlers (used when rollout is created)
	function AddNotifyHandlers =
	(
		callbacks.addScript #viewportChange "VFB_Rollout_TopLeft.NotifyViewportChange()" id:#VFB_Rollout_TopLeft_Callback
		callbacks.addScript #imageViewerUpdate "VFB_Rollout_TopLeft.NotifyImageViewerUpdate()" id:#VFB_Rollout_TopLeft_Callback
	)
	
	-- Install all notification handlers (used when rollout is destroyed)
	function RemoveNotifyHandlers =
	(
		-- this removes all callbacks registered against id:#VFB_Rollout_topLeft_Callback, regardless of callback type
		callbacks.removeScripts id:#VFB_Rollout_TopLeft_Callback
	)

	
	----------------------------------------------------------------------------
	-- UI Functions
	
	function UpdateUI =
	(
		EditRenderRegion.UpdateRegion() -- sync to the latest region mode first so the UI is up to date
		EditRegionBtn.checked = EditRenderRegion.isEditing
		AutoRegionSelectedBtn.checked = IsAutoRegionSelectedRenderType()
		
		local curRenderer = renderers.current
		if (classof curRenderer) == mental_ray_renderer then
		(
			local curRenderer = renderers.current
			IncludeSubsetPixelsCheck.checked = curRenderer.Enable_Subset_Pixel_Rendering
		)
		UpdateRegionWarning()
		
		UpdateViewportDropdown()

		RenderTypeDropdown.selection = GetRenderTypeDropdownIndex()

		RenderDialogBtn.checked = renderSceneDialog.IsOpen()
		EnvironmentDialogBtn.checked = envEffectsDialog.IsOpen()
	)
	
	-- Initialize the string tables and lists shared between functions
	function InitLists =
	(
		if renderTypeList==undefined do
		(
			renderTypeList = StringTable_to_StringList renderTypeTable
		)
			
		if renderTypeTableSorted==undefined do
		(
			renderTypeTableSorted = copy renderTypeTable #noMap
			qsort renderTypeTableSorted VFB_methods.LookupTableComparator
		)
	)
	
	function InitUI =
	(
		local curRenderer = renderers.current
		if (classof curRenderer) == mental_ray_renderer then
		(
			IncludeSubsetPixelsCheck.tooltip = IncludeSubsetPixelsCheckTooltip
			IncludeSubsetPixelsCheck.visible = true
		)else 
		(
			IncludeSubsetPixelsCheck.visible = false
		)
		
		RenderTypeDropdown.items = renderTypeList
		RenderTypeDropdown.selection = GetRenderTypeDropdownIndex()

		EditRegionBtn.tooltip = EditRegionBtnTooltip
		AutoRegionSelectedBtn.tooltip = AutoRegionSelectedBtnTooltip
		
		RegionWarningBtn.enabled = false
		
		-- generate the helper struct
		VFB_methods.viewportInfo = VFB_methods.GetViewportInfo()
		InitViewportDropdown()

		renderPresetList = renderPresetMRUList
		local renderPresetNames = (for entry in renderPresetList collect entry[1])

		-- add presets now and force size to be computed without the separator
		RenderPresetDropdown.items = renderPresetNames
		-- this forces the size of the dropped list to be recomputed
		local RenderPresetDropdownWidth = RenderPresetDropdown.width
		RenderPresetDropdown.width = RenderPresetDropdownWidth
		
		append renderPresetNames separator
		local renderPresetSelection = renderPresetnames.count
		append renderPresetNames LoadPresetString
		append renderPresetNames SavePresetString
		RenderPresetDropdown.items = renderPresetNames
		RenderPresetDropdown.selection = renderPresetSelection
		
		RenderDialogBtn.tooltip = RenderDialogActionItemName
		EnvironmentDialogBtn.Tooltip = EnvironmentDialogActionItemName

		UpdateUI()
	)

	-- Handler for the #viewportChange notification
	function NotifyViewportChange =
	(
		local curViewportInfo = VFB_methods.GetViewportInfo()
		local prevViewportInfo = VFB_methods.viewportInfo
		
		local sameViewportConfig = (VFB_methods.CompareViewportInfo curViewportInfo prevViewportInfo)
		selectedViewId = ViewportDropdownIndex_to_ViewId ViewportDropdown.selection
		if (not sameViewportConfig) then 
		(
			VFB_methods.viewportInfo = curViewportInfo 
			RefreshViewportDropdown()
		)
		else if (not LockToViewportBtn.checked) and (selectedViewId != viewport.activeViewportId) do (
			UpdateViewportDropdown()
		)
	)

	-- Handler for the #imageViewerUpdate notification
	function NotifyImageViewerUpdate =
	(
		UpdateUI()
	)

	
	on VFB_Rollout_TopLeft open do
	(
		InitLists()
		InitUI()
		AddNotifyHandlers()
	)
	on VFB_Rollout_TopLeft close do
	(
		RemoveNotifyHandlers()
		if VFB_methods.VFB_IsInitialized() do
		(	-- Should always be true, but could fail due to bugs (TO DO: Debug assert in MaxScript?)
			-- Save global values to use when the UI is launched next
			VFB_methods.showRollups = VFB_methods.VFB_Interface.showRollups
			VFB_methods.showOverlays = VFB_methods.VFB_Interface.showOverlays
		)
	)
	on RenderTypeDropdown selected index do
	(
		local renderType = RenderTypeTable[index][1]
		local autoRegionSelected = AutoRegionSelectedBtn.checked
		local convertedRenderType = (ConvertRenderType renderType autoRegionSelected)
		SetRenderType convertedRenderType
		VFB_methods.CommitRenderChanges()
		-- switch into region editing mode if not editing
		EditRenderRegion.UpdateRegion() -- handle any required mode changes
		if ((IsUserRegionRenderType renderType:convertedRenderType) and (not EditRenderRegion.isEditing))do (
			EditRenderRegion.EditRegion()
		)
		UpdateUI()
	)
	on EditRegionBtn changed state do
	(
		if (state != EditRenderRegion.isEditing) do (
			EditRenderRegion.EditRegion()
			UpdateUI() -- region editing can change the render mode.
		)
	)
	on AutoRegionSelectedBtn changed state do
	(
		local renderType = GetRenderType()
		local autoRegionSelected = state
		-- toggling on region selected, but not a region mode, switch it
		if (not IsRegionRenderType() and state) do (
			renderType =  #region
		)
		local convertedRenderType = (ConvertRenderType renderType autoRegionSelected)
		SetRenderType convertedRenderType
		VFB_methods.CommitRenderChanges() -- changed the render type, update the render dialog
		UpdateUI()
	)
	on ViewportDropdown selected index do
	(
		-- If render is not locked to a viewport ("use active view" is true) then switch the active viewport,
		-- otherwise if locked, update the render view id but don't change the active viewport
		local activeId = ViewportDropdownIndex_to_ViewId index
		if rendUseActiveView then viewport.activeViewportId = activeId
		else SetRendViewID (ViewportDropdownIndex_to_ViewId index)
	
		VFB_methods.CommitRenderChanges()
		UpdateUI()
	)
	on LockToViewportBtn changed state do
	(
		rendUseActiveView = not state
		
		-- If locking, change the render view index to match the dropdown
		-- If unlocking, chnage the dropdown to match the render view index
		if state then SetRendViewID (ViewportDropdownIndex_to_ViewId ViewportDropdown.selection)
		else ViewportDropdown.selection = ViewId_to_ViewportDropdownIndex rendViewID
		
		VFB_methods.CommitRenderChanges()
		
		UpdateViewportDropdown()
	)
	on RenderPresetDropdown selected index do
	(
		local lastIndex = renderPresetList.count
		local loadFilename = undefined
		local saveFilename = undefined
		if (index<=lastIndex) and (index>=1) do
		(
			loadFilename = renderPresetList[index][2]
		)
		if (index==(lastIndex+2)) do -- user selected ~LOADPRESETSTRING_CHECK~
		(
			loadFilename = getOpenFileName caption:RenderPresetsLoadCaption \
				filename:(GetDir #renderPresets + "\\") types:RenderPresetsFilespec
		)
		if (index==(lastIndex+3)) do -- user selected ~SAVEPRESETSTRING_CHECK~
		(
			saveFilename = getSaveFileName caption:RenderPresetsSaveCaption \
				filename:(GetDir #renderPresets + "\\") types:RenderPresetsFilespec
		)
		
		if( loadFilename!=undefined ) do
		(
			-- First parameter of zero indicates the production renderer (as opposed to material editor or ActiveShade)
			-- Second parameter of empty indicates the user should be prompted to select preset categories
			renderPresets.Load 0 loadFilename #{}
		)
		if( saveFilename!=undefined ) do
		(
			-- First parameter of zero indicates the production renderer (as opposed to material editor or ActiveShade)
			-- Second parameter of empty indicates the user should be prompted to select preset categories
			renderPresets.Save 0 saveFilename #{}
			InitUI() -- Update the new Render Preset list
		)
	)
	on RenderDialogBtn changed state do
	(
		if state then
			renderSceneDialog.Open()
		else
			renderSceneDialog.Close()
	)
	on EnvironmentDialogBtn changed state do
	(
		if state then
		(
			envEffectsDialog.Open()
			-- Set the correct tab in the dialog.
			-- Note the ID numbers are not documented.  Fetch them using tabbedDialogs.SetCurrentPage() with the given tab open.
			tabbedDialogs.SetCurrentPage #envEffects #(517034860, 435433537)
		)
		else
			envEffectsDialog.Close()		
	)
	
	on IncludeSubsetPixelsCheck changed state do
	(
		local curRenderer = renderers.current
		curRenderer.Enable_Subset_Pixel_Rendering = state
		VFB_methods.CommitMentalRayChanges()
	)	
)


-------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------
--
-- Top-Right Rollout
--

rollout VFB_Rollout_TopRight "VFB_Rollout_TopRight" width:120 height:62
(
	----------------------------------------------------------------------------
	-- LOCALIZATION [begin - first string only section]
	-- Translate the FIRST STRING ONLY of each line below
	
	button RenderBtn ~RENDERBTN_CAPTION~ pos:[4,4] width:104 height:24
	dropdownList RenderModeDropdown "" pos:[4,34] width:104 height:21

	-- LOCALIZATION [end - first string only section]
	----------------------------------------------------------------------------
	
	----------------------------------------------------------------------------
	-- LOCALIZATION [begin - translate everything section]
	-- Translate everything in quotes below
	
	local RenderBtnTooltip = ~RENDERBTNTOOLTIP~
	local RenderModeDropdownTooltip = ~RENDERMODEDROPDOWNTOOLTIP_CAPTION~
	local RenderModeList =
	#(
		~RENDERMODELIST_ITERATIVE~,
		~RENDERMODELIST_PRODUCTION~
	)
	-- LOCALIZATION [end - translate everything section]
	----------------------------------------------------------------------------
	
	
	----------------------------------------------------------------------------
	-- Notify Handlers
	
	-- Install all notification handlers (used when rollout is created)
	function AddNotifyHandlers =
	(
		callbacks.addScript #imageViewerUpdate "VFB_Rollout_TopRight.UpdateUI()" id:#VFB_Rollout_TopRight_Callback
	)
	
	-- Install all notification handlers (used when rollout is destroyed)
	function RemoveNotifyHandlers =
	(
		callbacks.removeScripts id:#VFB_Rollout_TopRight_Callback
	)


	----------------------------------------------------------------------------
	-- UI Functions
	
	function UpdateUI =
	(
		-- JOHNSON RELEASE SDK
		--RenderModeDropdown.selection = (if rendUseIterative then 1 else 2)
		-- JOHNSON PRE-RELEASE SDK
		RenderModeDropdown.selection = (if maxops.rendUseIterative then 1 else 2)
	)
	
	function InitUI =
	(
		RenderBtn.tooltip = RenderBtnTooltip
		RenderModeDropdown.items = RenderModeList
		RenderModeDropdown.tooltip = RenderModeDropdownTooltip
		
		UpdateUI()
	)
	
	on VFB_Rollout_TopRight open do
	(
		InitUI()
		AddNotifyHandlers()
	)
	
	on VFB_Rollout_TopRight close do
	(
		RemoveNotifyHandlers()
	)
	
	on RenderModeDropdown selected index do
	(
		VFB_methods.HandleRenderModeDropdown selected index
	)
	
	on RenderBtn pressed do
	(
		try
		(
			if maxops.rendUseIterative then
			(
				actionMan.executeAction 0 "59244"  -- Render: Render Iterative
			)
			else
			(
				actionMan.executeAction 0 "59243"  -- Render: Render Production
			)
		)
		catch
		(
		)
	)
	
) -- rollout VFB_Rollout_TopRight


-------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------
--
-- Bottom Rollout
--

rollout VFB_Rollout_Bottom "VFB_Rollout_Bottom" width:717 height:159
(
	
	----------------------------------------------------------------------------
	-- LOCALIZATION [begin - first string only section]
	-- Translate the FIRST STRING ONLY of each line below
	
	GroupBox IncludeInRenderGroup ~INCLUDEINRENDERGROUP_TRACE_BOUNCES_LIMITS_CAPTION~ pos:[378,73] width:~INCLUDEINRENDERGROUP_WIDTH~ height:80
	button IncludeRaytraceBtn ~INCLUDERAYTRACEBTN_CAPTION~ pos:[463,73] width:218 height:24

	spinner IncludeReflectionsMaxSpin "" pos:~INCLUDEREFLECTIONSMAXSPIN_POSITION~ width:~INCLUDEREFLECTIONSMAXSPIN_WIDTH~ height:16 range:[0,100,0] type:#integer
	spinner IncludeRefractionsMaxSpin "" pos:~INCLUDEREFRACTIONSMAXSPIN_POSITION~ width:~INCLUDEREFRACTIONSMAXSPIN_WIDTH~ height:16 range:[0,100,0] type:#integer
	spinner IncludeFinalGatherBouncesSpin "" pos:~INCLUDEFINALGATHERBOUNCESSPIN_POSITION~ width:~INCLUDEFINALGATHERBOUNCESSPIN_WIDTH~ height:16 range:[0,100,0] type:#integer

	
	label FGBouncesLabel ~FGBOUNCESLABEL_CAPTION~ pos:[384,131] width:~FGBOUNCESLABEL_WIDTH~ height:17
	label MaxRefractionLabel ~MAXREFRACTIONLABEL~ pos:[384,110] width:~MAXREFRACTIONLABEL_WIDTH~ height:16
	label MaxReflectionlabel ~MAXREFLECTIONLABEL~ pos:[384,89] width:~MAXREFLECTIONLABEL_WIDTH~ height:19	
	
	GroupBox ReUseGroup ~REUSEGROUP_CAPTION~ pos:[558,5] width:148 height:62
	checkbutton ReUseGeometryLockBtn "" pos:~REUSEGEOMETRYLOCKBTN_POSITION~ width:18 height:18 iconName:"Common/Lock" iconSize:[16,16]
	checkbox ReUseGeometryCheck ~REUSEGEOMETRYCHECK_CAPTION~ pos:~REUSEGEOMETRYCHECK_POSITION~ width:80 height:16
	button ReUseGeometryClearBtn "" pos:~REUSEGEOMETRYCLEARBTN_POSITION~ width:18 height:18 iconName:"RenderFrameWindow/ClearGeometryCache" iconSize:[16,16]
		
	checkbutton ReUseFinalGatherLockBtn "" pos:~REUSEFINALGATHERLOCKBTN_POSITION~ width:18 height:18 iconName:"Common/Lock" iconSize:[16,16]
	checkbox ReUseFinalGatherCheck ~REUSEFINALGATHERCHECK_CAPTION~ pos:~REUSEFINALGATHERCHECK_POSITION~ width:~REUSEFINALGATHERCHECK_WIDTH~ height:16
	button ReUseFinalGatherClearBtn "" pos:~REUSEFINALGATHERCLEARBTN_POSITION~ width:18 height:18 iconName:"RenderFrameWindow/ClearGeometryCache" iconSize:[16,16]
	
	label ImagePrecisionLabel ~IMAGEPRECISIONLABEL~ pos:[10,5] width:~IMAGEPRECISIONLABEL_WIDTH~ height:16
	label ImagePrecisionEdit "" pos:[10,22] width:161 height:16 style_sunkenedge:true
	slider ImagePrecisionSlider "" pos:[9,39] width:176 height:25 range:[1,6,2] type:#integer ticks:6

	label UnifiedPrecisionLabel ~UNIFIEDPRECISIONLABEL~ pos:[10,5] width:~IMAGEPRECISIONLABEL_WIDTH~ height:16
	label UnifiedPrecisionEdit "" pos:[10,22] width:161 height:16 style_sunkenedge:true
	slider UnifiedPrecisionSlider "" pos:[9,39] width:176 height:25 range:[1,11,2] type:#integer ticks:11
	
	label FinalGatherPrecisionLabel ~FINALGATHERPRECISIONLABEL~ pos:[378,5] width:160 height:16
	label FinalGatherPrecisionEdit "" pos:[378,22] width:160 height:16 style_sunkenedge:true
	slider FinalGatherPrecisionSlider "" pos:[378,38] width:176 height:25 range:[1,7,2] type:#integer ticks:7
	
	label GlossyReflectionPrecisionLabel ~GLOSSYREFLECTIONPRECISIONLABEL~ pos:[11,73] width:183 height:16
	label GlossyReflectionPrecisionEdit "" pos:[10,94] width:161 height:16 style_sunkenedge:true
	slider GlossyReflectionPrecisionSlider "" pos:[10,114] width:176 height:25 range:[1,13,2] type:#integer ticks:12
	
	label GlossyRefractionPrecisionLabel ~GLOSSYREFRACTIONPRECISIONLABEL~ pos:[195,73] width:180 height:16
	label GlossyRefractionPrecisionEdit "" pos:[195,94] width:161 height:16 style_sunkenedge:true
	slider GlossyRefractionPrecisionSlider "" pos:[195,115] width:176 height:25 range:[1,13,2] type:#integer ticks:12
	
	label SoftShadowPrecisionLabel ~SOFTSHADOWPRECISIONLABEL~ pos:[195,5] width:161 height:16
	label SoftShadowPrecisionEdit "" pos:[195,22] width:161 height:16 style_sunkenedge:true
	slider SoftShadowPrecisionSlider "" pos:[195,39] width:176 height:25 range:[1,11,2] type:#integer ticks:9		
	
	button RenderBtn ~RENDERBTN_RENDER_CAPTION~ pos:[558,108] width:147 height:42
	dropdownList RenderModeDropdown "" pos:[559,81] width:147 height:21
	-- LOCALIZATION [end - first string only section]
	----------------------------------------------------------------------------


	----------------------------------------------------------------------------
	-- LOCALIZATION [begin - translate everything section]
	-- Translate everything in quotes below

	local RenderBtnTooltip = ~RENDERBTNTOOLTIP_CAPTION~
	local RenderModeDropdownTooltip = ~RENDERMODEDROPDOWNTOOLTIP_STD_RENDERING_SETTINGS_DOES_NOT_SAVE_OUTPUT~
	local RenderModeList =
	#(
		~VFB_ROLLOUT_BOTTOM_RENDERMODELIST_ITERATIVE~,
		~VFB_ROLLOUT_BOTTOM_RENDERMODELIST_PRODUCTION~
	)

	local ReUseGeometryCheckTooltip = ~REUSEGEOMETRYCHECKTOOLTIP~
	local ReUseGeometryLockBtnTooltip =
		~LOCK_GEOMETRY_TRANSLATION~ +
		~OBJ_LEVEL_CHANGES_WILL_STILL_UPDATE~
	local ReUseGeometryClearBtnTooltip = ~REUSEGEOMETRYCLEARBTNTOOLTIP~

	local ReUseFinalgatherCheckTooltip = ~REUSEFINALGATHERCHECKTOOLTIP~
	local ReUseFinalGatherLockBtnTooltip = ~REUSEFINALGATHERLOCKBTNTOOLTIP~
	local ReUseFinalGatherClearBtnTooltip = ~REUSEFINALGATHERCLEARBTNTOOLTIP~

	local ReUseShadowMapsLockBtnTooltip = ~REUSESHADOWMAPSLOCKBTNTOOLTIP~
	
	Local IncludeReflectionsMaxSpinTooltip =  ~INCLUDEREFLECTIONSMAXSPINTOOLTIP~ +
		 ~INCLUDEREFLECTIONSMAXSPINTOOLTIP_RAY_REFLECT~
	
	Local IncludeRefractionsMaxSpinTooltip =  ~INCLUDEREFRACTIONSMAXSPINTOOLTIP~ +
		~INCLUDEREFRACTIONSMAXSPINTOOLTIP_RAY_REFRACTED~
	
	Local IncludeFinalGatherBouncesSpinTooltip = ~INCLUDEFINALGATHERBOUNCESSPINTOOLTIP~
	
	Local GlossyReflectionPrecisionSliderTooltip = ~GLOSSYREFLECTIONPRECISIONSLIDERTOOLTIP~+
		~GLOSSYREFLECTIONPRECISIONSLIDERTOOLTIP_EQUIVALENT_REFLECTION_GLOSSY_SAMPLES~+
		~GLOSSYREFLECTIONPRECISIONSLIDERTOOLTIP_CAN_TURN_REFLECTIONS_OFF~
	
	Local GlossyRefractionPrecisionSliderTooltip = ~GLOSSYREFRACTIONPRECISIONSLIDERTOOLTIP~ +
		~GLOSSYREFRACTIONPRECISIONSLIDERTOOLTIP_EQUIVALENT_CHANGING_REFRACTION_GLOSSY_SAMPLES~+
		~GLOSSYREFRACTIONPRECISIONSLIDERTOOLTIP_TURN_REFRACTIONS_OFF~
	
	Local SoftShadowPrecisionSliderTooltip = ~SOFTSHADOWPRECISIONSLIDERTOOLTIP_INC_OR_DEC_SOFT_SHADOWS~+
		~SOFTSHADOWPRECISIONSLIDERTOOLTIP_EQUIVALENT_SHADOW_SAMPLES~	
	
	Local FinalGatherPrecisionSliderTooltip = ~FINALGATHERPRECISIONSLIDERTOOLTIP_INC_OR_DEC_FINAL_GATHER~
	
	-- LOCALIZATION [end - translate everything section]
	----------------------------------------------------------------------------

	struct GlossyReflectionPrecisionPresetDataStruct
	(
		presetIndex = undefined,
		customIndex = undefined,
		customToggle = undefined,
		offIndex = undefined,
		presetSlider = undefined,
		presetEdit = undefined,
		
		presetTable =
		#( -- Preset name	          	-- Preset antialisaing values
			#(~PRESETTABLE_REFLECTIONS_OFF~,				        1.0	),			
			#(~PRESETTABLE_DRAFT~,							0.1	),
			#(~PRESETTABLE_LOW~,					    0.25),
			#(~PRESETTABLE_HALF_LOW~,						    0.5	),
			#(~PRESETTABLE_MEDIUM~ ,				    0.75),
			#(~PRESETTABLE_DEFAULT~,					    1.0	),
			#(~PRESETTABLE_NORMAL_QUALITY~,			1.5	),
			#(~PRESETTABLE_HIGH_QUALITY~,				2.0	),
			#(~PRESETTABLE_3_TIMES_HIGH_QUALITY~,			    3.0	),
			#(~PRESETTABLE_FIVE_TIMES_HIGH_QUALITY~,				5.0	),
			#(~PRESETTABLE_VERY_HIGH_QUALITY~,	    10.0	),			
			#(~PRESETTABLE_CUSTOM~,							    1.0   ) -- ~PRESETTABLE_CUSTOM~ value is dynamic
		),
		presetTableSorted = undefined,
		
		function FindPresetIndex =
		(
			local curRenderer = renderers.current
			local retval = curRenderer.glossyreflectionsprecision
			
			local glossyreflectionsPrecisionSearchIndex = undefined
			local glossyreflectionsPrecisionCurrentValue = curRenderer.glossyreflectionsprecision -- Get current settings			
			
			if (curRenderer.ReflectionsEnable == true) then
			(
				for i = 2 to presetTable.count while (glossyreflectionsPrecisionSearchIndex==undefined) do
				(
					item = presetTable[i]
					if	(item!=undefined) and (item[2]==glossyreflectionsPrecisionCurrentValue)  do
					(
						glossyreflectionsPrecisionSearchIndex = i
					)
				)
			)else
			(
				glossyreflectionsPrecisionSearchIndex = 1 ;
				curRenderer.glossyreflectionsprecision = 1.0 -- set it to default value
			)
			
			if glossyreflectionsPrecisionSearchIndex==undefined do glossyreflectionsPrecisionSearchIndex = customIndex
			glossyreflectionsPrecisionSearchIndex -- return value
		),

		function IsPresetMatch =
		(
			local curRenderer = renderers.current
			local glossyReflectionPrecisionPrevVal = presetTable[ presetIndex ][2]
 			local glossyReflectionPrecisionCurVal = curRenderer.glossyreflectionsprecision
			glossyReflectionPrecisionCurVal == glossyReflectionPrecisionPrevVal  -- return value
		),
		
		function CapturePreset index =
		(
			local curRenderer = renderers.current
			local item = presetTable[index]
			if (item!=undefined) do
			(
				item[2] = curRenderer.glossyreflectionsprecision
				presetTable[ index ] = item
			)		
		),
		
		function RestorePreset index =
		(
			local curRenderer = renderers.current
			local item = presetTable[index]
			if (item!=undefined) and (item[2]!=undefined) do
			(
				curRenderer.glossyreflectionsprecision = item[2]
				if index!=offIndex then
				(
					curRenderer.ReflectionsEnable = true
				)else
				(
					curRenderer.ReflectionsEnable = false
				)
				VFB_methods.CommitMentalRayChanges()
			)			
		),

		function OnChanged index =
		(
			RestorePreset index
			presetIndex = index			
		),

		function Init =
		(
			customIndex = presetTable.count
			offIndex = 1
		),
		
		function SupportStickyCustom =
		( -- True if the slider remains in place after going to Custom, until manually dragged
			false
		),
		function IsSettingOff =
		(  -- True if the internal system setting is "off"
			local curRenderer = renderers.current
			curRenderer.ReflectionsEnable == false
		)
	) 
	local glossyReflectionPrecisionPresetData = undefined	
		
	struct GlossyRefractionPrecisionPresetDataStruct
	(
		presetIndex = undefined,
		customIndex = undefined,
		customToggle = undefined,
		offIndex = undefined,
		presetSlider = undefined,
		presetEdit = undefined,
		
		presetTable =
		#( 	-- Preset name	           	-- Preset antialisaing values
			#(~PRESETTABLE_REFRACTIONS_OFF~,				       1.0	),			
			#(~PRESETTABLE_REFRACTIONS_DRAFT~,	    		           0.1	),
			#(~PRESETTABLE_REFRACTIONS_LOW~,		               0.25	),
			#(~PRESETTABLE_REFRACTION_HALF_LOW~,				           0.5	),
			#(~PRESETTABLE_REFRACTION_MEDIUM~ ,				   0.75	),
			#(~PRESETTABLE_REFRACTION_DEFAULT~,			           1.0	),
			#(~PRESETTABLE_REFRACTION_NORMAL_QUALITY~,		   1.5	),
			#(~PRESETTABLE_REFRACTION_HIGH_QUALITY~,		       2.0	),
			#(~PRESETTABLE_REFRACTION_3_TIMES_HIGH_QUALITY~,		       3.0	),
			#(~PRESETTABLE_REFRACTION_FIVE_TIMES_HIGH_QUALITY~,		       5.0	),
			#(~PRESETTABLE_REFRACTION_VERY_HIGH_QUALITY~,	   10.0	),			
			#(~PRESETTABLE_REFRACTION_CUSTOM~,				               1.0   ) -- ~PRESETTABLE_REFRACTION_CUSTOM~ value is dynamic
		),
		presetTableSorted = undefined,
		
		function FindPresetIndex =
		(
			local curRenderer = renderers.current
			local retval = curRenderer.glossyrefractionsprecision
			
			local glossyrefractionsPrecisionSearchIndex = undefined
			local glossyrefractionsPrecisionCurrentValue = curRenderer.glossyrefractionsprecision -- Get current settings			
			
			if (curRenderer.RefractionsEnable == true) then
			(
				for i = 2 to presetTable.count while (glossyrefractionsPrecisionSearchIndex==undefined) do
				(
					item = presetTable[i]
					if	(item!=undefined) and (item[2]==glossyrefractionsPrecisionCurrentValue)  do
					(
						glossyrefractionsPrecisionSearchIndex = i
					)
				)						
			)else
			(
				glossyrefractionsPrecisionSearchIndex = 1 ;
				curRenderer.glossyrefractionsprecision = 1.0 -- set it to default value
			)
			if glossyrefractionsPrecisionSearchIndex==undefined do glossyrefractionsPrecisionSearchIndex = customIndex
		
			glossyrefractionsPrecisionSearchIndex -- return value
		),

		function IsPresetMatch =
		(
			local curRenderer = renderers.current
			local glossyRefractionPrecisionPrevVal = presetTable[ presetIndex ][2]
 			local glossyRefractionPrecisionCurVal = curRenderer.glossyrefractionsprecision
			glossyRefractionPrecisionCurVal == glossyRefractionPrecisionPrevVal  -- return value
		),
		
		function CapturePreset index =
		(
			local curRenderer = renderers.current
			local item = presetTable[index]
			if (item!=undefined) do
			(
				item[2] = curRenderer.glossyrefractionsprecision
				presetTable[ index ] = item
			)		
		),
		
		function RestorePreset index =
		(
			local curRenderer = renderers.current
			local item = presetTable[index]
			if (item!=undefined) and (item[2]!=undefined) do
			(
				curRenderer.glossyrefractionsprecision = item[2]
				if index!=offIndex then
				(
					curRenderer.RefractionsEnable = true
				)else
				(
					curRenderer.RefractionsEnable = false
				)
				VFB_methods.CommitMentalRayChanges()
			)			
		),

		function OnChanged index =
		(
			RestorePreset index
			presetIndex = index			
		),

		function Init =
		(
			customIndex = presetTable.count
			offIndex = 1
		),
		
		function SupportStickyCustom =
		( -- True if the slider remains in place after going to Custom, until manually dragged
			false
		),
		function IsSettingOff =
		(  -- True if the internal system setting is "off"
			local curRenderer = renderers.current
		 	curRenderer.RefractionsEnable == false
		)
	) 
	local glossyRefractionPrecisionPresetData = undefined	
		
	struct SoftShadowPrecisionPresetDataStruct
	(
		presetIndex = undefined,
		customIndex = undefined,
		customToggle = undefined,
		offIndex = undefined,
		presetSlider = undefined,
		presetEdit = undefined,
		
		presetTable =
		#( -- Preset name	          	-- Preset antialisaing values
			#(~PRESETTABLE_SOFTSHADOW_OFF~,				           1.0	),			
			#(~PRESETTABLE_SOFTSHADOW_VERY_LOW~,				     0.125),
			#(~PRESETTABLE_SOFTSHADOW_LOW~,					         0.25	),
			#(~PRESETTABLE_SOFTSHADOW_MEDIUM~,						   0.5	),
			#(~PRESETTABLE_SOFTSHADOW_DEFAULT~,					     1.0	),
			#(~PRESETTABLE_SOFTSHADOW_HIGH_QUALITY~,				 2.0	),
			#(~PRESETTABLE_SOFTSHADOW_4_TIMES_HIGH_QUALITY~, 4.0	),
			#(~PRESETTABLE_SOFTSHADOW_8_TIMES_HIGH_QUALITY~, 8.0	),
			#(~PRESETTABLE_SOFTSHADOW_VERY_HIGH_QUALITY~,	   16.0	),
			#(~PRESETTABLE_SOFTSHADOW_CUSTOM~,				       1.0  )			
		),
		presetTableSorted = undefined,
		
		function FindPresetIndex =
		(
			local curRenderer = renderers.current
			local retval = curRenderer.softshadowsprecision
			
			local softshadowPrecisionSearchIndex = undefined
			local softshadowPrecisionCurrentValue = curRenderer.softshadowsprecision -- Get current settings			
			
			if ( rendSimplifyAreaLights == false) then
			(
				for i = 2 to presetTable.count while (softshadowPrecisionSearchIndex==undefined) do
				(
					item = presetTable[i]
					if	(item!=undefined) and (item[2]==softshadowPrecisionCurrentValue)  do
					(
						softshadowPrecisionSearchIndex = i
					)
				)
			)else
			(
				softshadowPrecisionSearchIndex = offIndex
			)
			if softshadowPrecisionSearchIndex==undefined do softshadowPrecisionSearchIndex = customIndex
			softshadowPrecisionSearchIndex -- return value
		),

		function IsPresetMatch =
		(
			local curRenderer = renderers.current
			local softshadowPrecisionPrevVal = presetTable[ presetIndex ][2]
 			local softshadowPrecisionCurVal = curRenderer.softshadowsprecision
			softshadowPrecisionCurVal == softshadowPrecisionPrevVal  -- return value
		),
		
		function CapturePreset index =
		(
			local curRenderer = renderers.current
			local item = presetTable[index]
			if (item!=undefined) do
			(
				item[2] = curRenderer.softshadowsprecision
				presetTable[ index ] = item
			)		
		),
		
		function RestorePreset index =
		(
			local curRenderer = renderers.current
			local item = presetTable[index]
			if (item!=undefined) and (item[2]!=undefined) do
			(
				curRenderer.softshadowsprecision = item[2]
				local s = if (index==offIndex) then true else false
				if( s!=rendSimplifyAreaLights ) do
				(
					rendSimplifyAreaLights = s
					VFB_methods.CommitRenderChanges() -- Update the "Area Lights/Shadows as Points" checkbox
				)
				VFB_methods.CommitMentalRayChanges()
			)			
		),

		function OnChanged index =
		(
			RestorePreset index
			presetIndex = index			
		),

		function Init =
		(
			customIndex = presetTable.count
			offIndex = 1
		),
		
		function SupportStickyCustom =
		( -- True if the slider remains in place after going to Custom, until manually dragged
			false
		),
		function IsSettingOff = 
		( -- True if the internal system setting is "off"
			rendSimplifyAreaLights == true
		)
	) 
	local softShadowPrecisionPresetData = undefined		
	
	
	----------------------------------------------------------------------------
	-- Image Precision Slider - helper class
	
	struct ImagePrecisionPresetDataStruct
	(
		----------------------------------------------------------------------------
		-- LOCALIZATION [begin - translate everything section]
		-- Translate everything in quotes below
		presetIndex = undefined,
		customIndex = undefined,
		customToggle = undefined,
		offIndex = undefined,
		presetSlider = undefined,
		presetEdit = undefined,
		presetFormatString = ~PRESETFORMATSTRING~,
		
		presetTable =
		#( -- Preset text (dynamic)		-- Preset name		-- Preset antialisaing values
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_DRAFT~,			[-3, -1]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_LOW~,				[-2,  0]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_MEDIUM~,			[-1,  1]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_HIGH~,				[ 0,  2]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_VERY_HIGH~,		[ 1,  3]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_CUSTOM~,			[ 0,  0]	) -- ~PRESETTABLE_IMAGEPRECISION_CUSTOM~ value is dynamic
		),
		presetTableSorted = undefined,
		
		stringTable =
		#( -- Antialisaing value		-- Antialiasing value text
			#( -3,						"1/64"	),
			#( -2,						"1/16"	),
			#( -1,						"1/4"	),
			#(  0,						"1"		),
			#(  1,						"4"		),
			#(  2,						"16"	),
			#(  3,						"64"	),
			#(  4,						"256"	),
			#(  5,						"1024"	)
		),
		stringTableSorted,
	
		-- LOCALIZATION [end - translate everything section]
		----------------------------------------------------------------------------
		
		----------------------------------------------------------------------------
		-- Image Precision Slider - helper functions
		
		-- ImagePrecisionPresetDataStruct.StringLookup()
		function StringLookup val =
		(
			VFB_methods.StringTableLookup val stringTableSorted
		),
		
		-- ImagePrecisionPresetDataStruct.FindPresetIndex()
		function FindPresetIndex =
		(
			local curRenderer = renderers.current
			local imagePrecisionSearchIndex = undefined
			local imagePrecisionCurrentValue = \
				[curRenderer.MinimumSamples, curRenderer.MaximumSamples] -- Get current settings
			
			for i = 1 to presetTable.count while (imagePrecisionSearchIndex==undefined) do
			(
				item = presetTable[i]
				if	(item!=undefined) and (item[3]==imagePrecisionCurrentValue)  do
				(
					imagePrecisionSearchIndex = i
				)
			)						
			
			if imagePrecisionSearchIndex==undefined do imagePrecisionSearchIndex = customIndex
			imagePrecisionSearchIndex -- return value
		),
		
		-- ImagePrecisionPresetDataStruct.IsPresetMatch()
		function IsPresetMatch =
		(
			local curRenderer = renderers.current
			local imagePrecisionPrevVal = presetTable[ presetIndex ][3]
			local imagePrecisionCurVal = [curRenderer.MinimumSamples, curRenderer.MaximumSamples]
			imagePrecisionCurVal == imagePrecisionPrevVal  -- return value
		),
		
		function UpdatePresetText index =
		(
			local item = presetTable[index]
			if ((item!=undefined) and (item[3]!=undefined)) do
			(
				local strStream = StringStream ""
				local minStr = StringLookup item[3].x
				local maxStr = StringLookup item[3].y
				format presetFormatString item[2] minStr maxStr to:strStream			
				item[1] = strStream as String
				
				presetTable[ index ] = item
			)
		),

		-- ImagePrecisionPresetDataStruct.CapturePreset()
		-- Captures image precision settings into a preset
		function CapturePreset index =
		(
			local curRenderer = renderers.current
			local item = presetTable[index]
			if (item!=undefined) do
			(
				item[3] = [curRenderer.MinimumSamples, curRenderer.MaximumSamples]
				presetTable[ index ] = item
				UpdatePresetText index
			)
		),
		
		-- ImagePrecisionPresetDataStruct.RestorePreset()
		-- Restores image precision settings into the UI
		function RestorePreset index =
		(
			local curRenderer = renderers.current
			local item = presetTable[index]
			if (item!=undefined) and (item[3]!=undefined) do
			(
				curRenderer.MinimumSamples = item[3].x
				curRenderer.MaximumSamples = item[3].y
				VFB_methods.CommitMentalRayChanges()
			)
		),
		
		-- ImagePrecisionPresetDataStruct.OnChanged()
		function OnChanged index =
		(
			RestorePreset index
			presetIndex = index
		),
		
		-- ImagePrecisionPresetDataStruct.Init()
		function Init =
		(
			if stringTableSorted==undefined do
			(
				stringTableSorted = copy stringTable #noMap
				qsort stringTableSorted VFB_methods.LookupTableComparator
			)
			-- Update the test values in the table
			for i = 1 to presetTable.count do UpdatePresetText i
			customIndex = presetTable.count
			offIndex = #unsupported
		),
		
		function SupportStickyCustom =
		( -- True if the slider remains in place after going to Custom, until manually dragged
			true
		),
		function IsSettingOff = 
		( -- True if the internal system setting is "off"
			false  -- not supported
		)
	) -- struct ImagePrecisionPresetDataStruct [end]
	local imagePrecisionPresetData = undefined






	struct UnifiedPrecisionPresetDataStruct
	(
		----------------------------------------------------------------------------
		-- LOCALIZATION [begin - translate everything section]
		-- Translate everything in quotes below
		presetIndex = undefined,
		customIndex = undefined,
		customToggle = undefined,
		offIndex = undefined,
		presetSlider = undefined,
		presetEdit = undefined,
		presetFormatString = ~PRESETFORMATSTRINGU~,
		
		presetTable =
		#( -- Preset text (dynamic)		-- Preset name		-- Preset antialisaing values
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_DRAFT~,				[0.1, 0.1]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_DRAFT~,			    [1.0, 0.1]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_LOW~,				[1.0, 0.25]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_LOW~,				[1.0, 0.5]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_MEDIUM~,			[1.0, 1.0]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_MEDIUM~,			[1.0, 1.5]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_HIGH~,				[1.0, 2.0]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_HIGH~,				[2.0, 3.0]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_VERY_HIGH~,		    [4.0, 5.0]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_VERY_HIGH~,		    [4.0, 8.0]	),
			#(undefined,				~PRESETTABLE_IMAGEPRECISION_CUSTOM~,			[0,  0]	) -- ~PRESETTABLE_IMAGEPRECISION_CUSTOM~ value is dynamic
		),
		presetTableSorted = undefined,
		
		-- LOCALIZATION [end - translate everything section]
		----------------------------------------------------------------------------
		
		----------------------------------------------------------------------------
		-- Unified Precision Slider - helper functions
			
		-- UnifiedPrecisionPresetDataStruct.FindPresetIndex()
		function FindPresetIndex =
		(
			local curRenderer = renderers.current
			local UnifiedPrecisionSearchIndex = undefined
			local UnifiedPrecisionCurrentValue = \
				[curRenderer.unifiedMinSamples, curRenderer.unifiedQuality] -- Get current settings
			
			for i = 1 to presetTable.count while (UnifiedPrecisionSearchIndex==undefined) do
			(
				item = presetTable[i]
				if	(item!=undefined) and (item[3]==UnifiedPrecisionCurrentValue)  do
				(
					UnifiedPrecisionSearchIndex = i
				)
			)						
			
			if UnifiedPrecisionSearchIndex==undefined do UnifiedPrecisionSearchIndex = customIndex
			UnifiedPrecisionSearchIndex -- return value
		),
		
		-- UnifiedPrecisionPresetDataStruct.IsPresetMatch()
		function IsPresetMatch =
		(
			local curRenderer = renderers.current
			local UnifiedPrecisionPrevVal = presetTable[ presetIndex ][3]
			local UnifiedPrecisionCurVal = [curRenderer.unifiedMinSamples, curRenderer.unifiedQuality]
			UnifiedPrecisionCurVal == UnifiedPrecisionPrevVal  -- return value
		),
		
		function UpdatePresetText index =
		(
			local item = presetTable[index]
			if ((item!=undefined) and (item[3]!=undefined)) do
			(
				local strStream = StringStream ""
				local minStr = item[3].x as string
				local maxStr = item[3].y as string
				format presetFormatString item[2] minStr maxStr to:strStream			
				item[1] = strStream as String
				
				presetTable[ index ] = item
			)
		),

		-- UnifiedPrecisionPresetDataStruct.CapturePreset()
		-- Captures image precision settings into a preset
		function CapturePreset index =
		(
			local curRenderer = renderers.current
			local item = presetTable[index]
			if (item!=undefined) do
			(
				item[3] = [curRenderer.unifiedMinSamples, curRenderer.unifiedQuality]
				presetTable[ index ] = item
				UpdatePresetText index
			)
		),
		
		-- UnifiedPrecisionPresetDataStruct.RestorePreset()
		-- Restores image precision settings into the UI
		function RestorePreset index =
		(
			local curRenderer = renderers.current
			local item = presetTable[index]
			if (item!=undefined) and (item[3]!=undefined) do
			(
				curRenderer.unifiedMinSamples = item[3].x
				curRenderer.unifiedQuality    = item[3].y
				VFB_methods.CommitMentalRayChanges()
			)
		),
		
		-- UnifiedPrecisionPresetDataStruct.OnChanged()
		function OnChanged index =
		(
			RestorePreset index
			presetIndex = index
		),
		
		-- UnifiedPrecisionPresetDataStruct.Init()
		function Init =
		(
			-- Update the test values in the table
			for i = 1 to presetTable.count do UpdatePresetText i
			customIndex = presetTable.count
			offIndex = #unsupported
		),
		
		function SupportStickyCustom =
		( -- True if the slider remains in place after going to Custom, until manually dragged
			true
		),
		function IsSettingOff = 
		( -- True if the internal system setting is "off"
			false  -- not supported
		)
	) -- struct UnifiedPrecisionPresetDataStruct [end]
	local UnifiedPrecisionPresetData = undefined








	struct FinalGatherPresetDataStruct
	(
		----------------------------------------------------------------------------
		-- LOCALIZATION [begin - translate everything section]
		-- Translate everything in quotes below
		presetIndex = undefined,
		customIndex = undefined,
		customToggle = undefined,
		offIndex = undefined,
		presetSlider = undefined,
		presetEdit = undefined,
		
		presetTable =
		#(
		),
		
		-- LOCALIZATION [end - translate everything section]
		----------------------------------------------------------------------------
		
		----------------------------------------------------------------------------
		-- Final Gather Slider - helper functions

		-- FinalGatherPresetDataStruct.FindPresetIndex()
		function FindPresetIndex =
		(
			-- The current slider value is maintained by the code because it can be
			-- changed from the render settings dialog.
			local curRenderer = renderers.current
			if not curRenderer.FinalGatherEnable2 then
			(
				offIndex
			)
			else
			(
				local retval = curRenderer.FindFinalGatherPreset()
				if retval>0 then (retval+1)  -- Add 1 to account for the "off" preset
				else customIndex -- return value
			)			
		),
		
		-- FinalGatherPresetDataStruct.IsPresetMatch()
		function IsPresetMatch =
		(
			local curRenderer = renderers.current
			curRenderer.FindFinalGatherPreset() == (presetIndex - 1) -- Subtract 1 to account for the "off" preset 
		),
		
		-- FinalGatherPresetDataStruct.CapturePreset()
		function CapturePreset index =
		(
			local curRenderer = renderers.current
			curRenderer.CaptureFinalGatherPreset (index - 1)  -- Subtract 1 to account for the "off" preset
		),
		
		-- FinalGatherPresetDataStruct.RestorePreset()
		function RestorePreset index =
		(
			local curRenderer = renderers.current
			if( index==offIndex ) then
			( -- When Final Gather is off, use settings from the first preset, except disable final gather
				-- NOTE: setting FinalGatherEnable2 also commits all UI values into internal values.
				-- This should either be done before restoring, or restoring must be followed by a commit.
				curRenderer.FinalGatherEnable2 = false
				curRenderer.RestoreFinalGatherPreset 1
			)
			else
			(
				-- NOTE: setting FinalGatherEnable2 also commits all UI values into internal values.
				-- This should either be done before restoring, or restoring must be followed by a commit.
				curRenderer.FinalGatherEnable2 = true
				curRenderer.RestoreFinalGatherPreset (index - 1)  -- Subtract 1 to account for the "off" preset
			)
		),
		
		-- FinalGatherPresetDataStruct.OnChanged()
		function OnChanged index =
		(
			RestorePreset index
			presetIndex = index
		),
		
		-- FinalGatherPresetDataStruct.Init()
		function Init =
		(
			local curRenderer = renderers.current
			local numPresets = curRenderer.numFinalGatherPresets
			presetTable[1] = #( ~FINALGATHER_DISABLED~ )
			local i
			for i = 1 to numPresets do
			(
				local item = #( (curRenderer.GetFinalGatherPresetName i) )
				presetTable[ i + 1 ] = item  -- Add 1 to account for the "off" preset
			)
			customIndex = numPresets+1
			offIndex = 1
		),
		
		function SupportStickyCustom =
		( -- True if the slider remains in place after going to Custom, until manually dragged
			false
		),
		function IsSettingOff = 
		( -- True if the internal system setting is "off"
			local curRenderer = renderers.current 
			curRenderer.FinalGatherEnable2 == false
		)
	) -- struct FinalGatherPresetDataStruct [end]
	local finalGatherPresetData = undefined

	----------------------------------------------------------------------------
	-- Notify Handlers
	
	-- Install all notification handlers (used when rollout is created)
	function AddNotifyHandlers =
	(
		callbacks.addScript #imageViewerUpdate "VFB_Rollout_Bottom.UpdateUI()" id:#VFB_Rollout_Bottom_Callback
	)
	
	-- Install all notification handlers (used when rollout is destroyed)
	function RemoveNotifyHandlers =
	(
		callbacks.removeScripts id:#VFB_Rollout_Bottom_Callback
	)
	
	
	----------------------------------------------------------------------------
	-- UI Functions
	
	function UpdatePresetSlider presetData =
	(
		local presetIndex = presetData.presetIndex
		if presetData.IsSettingOff() then
		(	-- Setting has been turned off, update slider to match
			presetIndex = presetData.offIndex -- skip the IsPresetMatch
		) else
		(
			if presetData.SupportStickyCustom() then
			(
				if not presetData.IsPresetMatch() then
				(	-- User changed a value outside our UI
					presetIndex = presetData.customIndex
					presetData.CapturePreset presetData.customIndex -- Capture custom value
				)
			)
			else
			(	-- Try to find the right index
				presetIndex = presetData.FindPresetIndex()
			)
		)

		
		-- Set slider to custom position
		presetData.CustomToggle = (presetIndex == presetData.customIndex)
		
		presetData.presetIndex = presetIndex	
		-- Number of ticks is one less than number of presets; no official slider position for "custom"
		presetData.presetSlider.value = if presetData.customToggle then (presetData.customIndex-1) else presetData.presetIndex		
		presetData.presetEdit.text = presetData.presetTable[ presetIndex ][1]
	)
	
	function UpdateUI =
	(
		local curRenderer = renderers.current
		

		IncludeReflectionsMaxSpin.value = curRenderer.MaximumReflections
		IncludeReflectionsMaxSpin.enabled = curRenderer.ReflectionsEnable
		
	
		IncludeRefractionsMaxSpin.value = curRenderer.MaximumRefractions
		IncludeRefractionsMaxSpin.enabled= curRenderer.RefractionsEnable

		IncludeRaytraceBtn.visible = not curRenderer.RaytraceEnable

		IncludeReflectionsMaxSpin.visible = curRenderer.RaytraceEnable

		IncludeRefractionsMaxSpin.visible = curRenderer.RaytraceEnable
		
		local finalGatherEnable = curRenderer.FinalGatherEnable2

		IncludeFinalGatherBouncesSpin.value = curRenderer.FinalGatherBounces
		IncludeFinalGatherBouncesSpin.enabled = finalGatherEnable
		
		ReUseFinalGatherLockBtn.checked = curRenderer.FinalGatherFreeze
		ReUseFinalGatherLockBtn.enabled = finalGatherEnable and curRenderer.UseFinalGatherFile
		ReUseFinalGatherCheck.checked = curRenderer.UseFinalGatherFile
		ReUseFinalGatherCheck.enabled = finalGatherEnable
		
		local geometryCacheEnable = curRenderer.EnableGeometryCache
		ReUseGeometryLockBtn.checked = curRenderer.LockGeometryCache
		ReUseGeometryLockBtn.enabled = geometryCacheEnable
		ReUseGeometryCheck.state = geometryCacheEnable

		if renderers.current.unifiedEnable then
		(
			UnifiedPrecisionLabel.visible = true
			UnifiedPrecisionEdit.visible = true
			UnifiedPrecisionSlider.visible = true
			ImagePrecisionLabel.visible = false
			ImagePrecisionEdit.visible = false
			ImagePrecisionSlider.visible = false
		)
		else
		(
			UnifiedPrecisionLabel.visible = false
			UnifiedPrecisionEdit.visible = false
			UnifiedPrecisionSlider.visible = false
			ImagePrecisionLabel.visible = true
			ImagePrecisionEdit.visible = true
			ImagePrecisionSlider.visible = true
		)

		UpdatePresetSlider imagePrecisionPresetData
		UpdatePresetSlider UnifiedPrecisionPresetData

		-- Reflection/Refraction/Shadow/Final Gather sliders always update to match internal settings.
		-- Image Precision slider always switches to "custom" if the internal setting is changed outside the slider.

		UpdatePresetSlider glossyReflectionPrecisionPresetData
		
		UpdatePresetSlider glossyRefractionPrecisionPresetData
		
		UpdatePresetSlider softShadowPrecisionPresetData
		
		UpdatePresetSlider finalGatherPresetData
		
		VFB_methods.glossyReflectionPrecisionPresetData = glossyReflectionPrecisionPresetData 
		VFB_methods.glossyRefractionPrecisionPresetData = glossyRefractionPrecisionPresetData 
		VFB_methods.softShadowPrecisionPresetData = softShadowPrecisionPresetData 	
		
		VFB_methods.imagePrecisionPresetData = imagePrecisionPresetData -- Hold values globally
		VFB_methods.UnifiedPrecisionPresetData = UnifiedPrecisionPresetData -- Hold values globally
		VFB_methods.finalGatherPresetData = finalGatherPresetData -- Hold values globally
		
		RenderModeDropdown.selection = (if maxops.rendUseIterative then 1 else 2)
	)
	
	function InitLists =
	(
		local presetData

		-- If preset data is not set, fetch the copy stored globally.  If still not available, make a new copy.
		presetData = imagePrecisionPresetData
		if presetData==undefined do
		(
			presetData = VFB_methods.imagePrecisionPresetData
			if presetData==undefined do
			(
				presetData = ImagePrecisionPresetDataStruct()
				presetData.Init()
			)
		)
		imagePrecisionPresetData = presetData



		presetData = UnifiedPrecisionPresetData
		if presetData==undefined do
		(
			presetData = VFB_methods.UnifiedPrecisionPresetData
			if presetData==undefined do
			(
				presetData = UnifiedPrecisionPresetDataStruct()
				presetData.Init()
			)
		)
		UnifiedPrecisionPresetData = presetData


			
		
		presetData = glossyReflectionPrecisionPresetData
		if presetData==undefined do
		(
			presetData = VFB_methods.glossyReflectionPrecisionPresetData
			if presetData==undefined do
			(
				presetData = glossyReflectionPrecisionPresetDataStruct()
				presetData.Init()
			)
		)
		glossyReflectionPrecisionPresetData = presetData

		presetData = glossyRefractionPrecisionPresetData
		if presetData==undefined do
		(
			presetData = VFB_methods.glossyRefractionPrecisionPresetData
			if presetData==undefined do
			(
				presetData = glossyRefractionPrecisionPresetDataStruct()
				presetData.Init()
			)
		)
		glossyRefractionPrecisionPresetData = presetData

		presetData = softShadowPrecisionPresetData
		if presetData==undefined do
		(
			presetData = VFB_methods.softShadowPrecisionPresetData
			if presetData==undefined do
			(
				presetData = softShadowPrecisionPresetDataStruct()
				presetData.Init()
			)
		)
		softShadowPrecisionPresetData = presetData
		
		-- If preset data is not set, fetch the copy stored globally.  If still not available, make a new copy.
		presetData = finalGatherPresetData
		if presetData==undefined do
		(
			presetData = VFB_methods.finalGatherPresetData
			if presetData==undefined do
			(
				presetData = FinalGatherPresetDataStruct()
				presetData.Init()
			)
		)
		finalGatherPresetData = presetData
	)
	
	function InitPresetSlider presetData presetSlider presetEdit =
	(
		presetData.presetSlider = presetSlider
		presetData.presetEdit = presetEdit
		
		if presetData.presetIndex==undefined do
		(
			presetData.CapturePreset presetData.customIndex
			presetData.presetIndex = presetData.FindPresetIndex()
			presetData.customToggle = (presetData.presetIndex==presetData.customIndex)
		)

		-- Number of ticks is one less than number of presets; no official slider position for "custom"
		presetData.presetSlider.ticks = (presetData.presetTable.count-1)
		presetData.presetSlider.range.y = (presetData.presetTable.count-1)
		presetData.presetSlider.value = if presetData.customToggle then (presetData.customIndex-1) else presetData.presetIndex
		
	)
	
	function InitUI =
	(		
		RenderBtn.tooltip = RenderBtnTooltip
		RenderModeDropdown.items = RenderModeList
		RenderModeDropdown.tooltip = RenderModeDropdownTooltip

		ReUseGeometryCheck.tooltip = ReUseGeometryCheckTooltip
		ReUseGeometryLockBtn.tooltip = ReUseGeometryLockBtnTooltip
		ReUseGeometryClearBtn.tooltip = ReUseGeometryClearBtnTooltip

		ReUseFinalGatherCheck.tooltip = ReUseFinalGatherCheckTooltip
		ReUseFinalGatherLockBtn.tooltip = ReUseFinalGatherLockBtnTooltip
		ReUseFinalGatherClearBtn.tooltip = ReUseFinalGatherClearBtnTooltip
		
		IncludeReflectionsMaxSpin.tooltip = IncludeReflectionsMaxSpinTooltip
		IncludeRefractionsMaxSpin.tooltip =IncludeRefractionsMaxSpinTooltip
		IncludeFinalGatherBouncesSpin.tooltip = IncludeFinalGatherBouncesSpinTooltip
		
        GlossyReflectionPrecisionSlider.tooltip = GlossyReflectionPrecisionSliderTooltip 	
        GlossyRefractionPrecisionSlider.tooltip = GlossyRefractionPrecisionSliderTooltip  	
        SoftShadowPrecisionSlider.tooltip = SoftShadowPrecisionSliderTooltip 
		FinalGatherPrecisionSlider.tooltip  = FinalGatherPrecisionSliderTooltip
		
		InitPresetSlider imagePrecisionPresetData imagePrecisionSlider imagePrecisionEdit
		
		InitPresetSlider UnifiedPrecisionPresetData UnifiedPrecisionSlider UnifiedPrecisionEdit
		
		InitPresetSlider glossyReflectionPrecisionPresetData glossyReflectionPrecisionSlider glossyReflectionPrecisionEdit	

		InitPresetSlider glossyRefractionPrecisionPresetData glossyRefractionPrecisionSlider glossyRefractionPrecisionEdit	

		InitPresetSlider softShadowPrecisionPresetData softShadowPrecisionSlider softShadowPrecisionEdit	
		
		InitPresetSlider finalGatherPresetData	finalGatherPrecisionSlider finalGatherPrecisionEdit
		
		UpdateUI()
	)
	


	
	
	
	
	on VFB_Rollout_Bottom open do
	(
		InitLists()
		InitUI()
		AddNotifyHandlers()
	)
	on VFB_Rollout_Bottom close do
	(
		RemoveNotifyHandlers()
	)
	on IncludeRaytraceBtn pressed do
	(
		local curRenderer = renderers.current
		curRenderer.RaytraceEnable = true
		VFB_methods.CommitMentalRayChanges()
		UpdateUI()
	)
	on IncludeReflectionsMaxSpin changed val do
	(
		local curRenderer = renderers.current
		curRenderer.MaximumReflections = val
		VFB_methods.CommitMentalRayChanges()
	)
	on IncludeRefractionsMaxSpin changed val do
	(
		local curRenderer = renderers.current
		curRenderer.MaximumRefractions = val
		VFB_methods.CommitMentalRayChanges()
	)
	on IncludeFinalGatherBouncesSpin changed val do
	(
		local curRenderer = renderers.current
		curRenderer.FinalGatherBounces = val
		VFB_methods.CommitMentalRayChanges()
	)
	on ReUseGeometryLockBtn changed state do
	(
		local curRenderer = renderers.current
		curRenderer.LockGeometryCache = state
		VFB_methods.CommitMentalRayChanges()
	)
	on ReUseGeometryCheck changed state do
	(
		local curRenderer = renderers.current
		curRenderer.EnableGeometryCache = state
		VFB_methods.CommitMentalRayChanges()
		UpdateUI() -- Enable/Disable lock button
	)
	on ReUseGeometryClearBtn pressed do
	(
		local curRenderer = renderers.current
		curRenderer.ClearGeometryCache()
	)
	on ReUseFinalGatherLockBtn changed state do
	(
		local curRenderer = renderers.current
		curRenderer.FinalGatherFreeze = state
		VFB_methods.CommitMentalRayChanges()
	)
	on ReUseFinalGatherCheck changed state do
	(
		local curRenderer = renderers.current
		if state then 
		( 
			if curRenderer.FinalGatherFilename == "" do
			(
				curRenderer.FinalGatherFilename = curRenderer.FinalGatherTempFilename
			)
			curRenderer.UseFinalGatherFile = true
		)
		else curRenderer.UseFinalGatherFile = false
		VFB_methods.CommitMentalRayChanges()
		UpdateUI() -- Enable/Disable lock button		
	)
	on ReUseFinalGatherClearBtn pressed do
	(
		local curRenderer = renderers.current
		curRenderer.DeleteFinalGatherFile()
	)
	on ImagePrecisionSlider changed index do
	(
		-- Moving the slider always turns off "custom"; no official slider position for "custom"
		imagePrecisionPresetData.customToggle = false
		imagePrecisionPresetData.OnChanged index
		VFB_methods.CommitMentalRayChanges()
		UpdateUI()
	)
	on UnifiedPrecisionSlider changed index do
	(
		-- Moving the slider always turns off "custom"; no official slider position for "custom"
		UnifiedPrecisionPresetData.customToggle = false
		UnifiedPrecisionPresetData.OnChanged index
		VFB_methods.CommitMentalRayChanges()
		UpdateUI()
	)
	on FinalGatherPrecisionSlider changed index do
	(
		-- Moving the slider always turns off "custom"; no official slider position for "custom"
		finalGatherPresetData.customToggle = false
		finalGatherPresetData.OnChanged index
		VFB_methods.CommitMentalRayChanges()
		UpdateUI()
	)
	on GlossyReflectionPrecisionSlider changed index do
	(
		-- Moving the slider always turns off "custom"; no official slider position for "custom"
		glossyReflectionPrecisionPresetData.customToggle = false
		glossyReflectionPrecisionPresetData.OnChanged index
		VFB_methods.CommitMentalRayChanges()
		UpdateUI()
	)
	on GlossyRefractionPrecisionSlider changed index do
	(
		-- Moving the slider always turns off "custom"; no official slider position for "custom"
		glossyRefractionPrecisionPresetData.customToggle = false
		glossyRefractionPrecisionPresetData.OnChanged index
		VFB_methods.CommitMentalRayChanges()
		UpdateUI()
	)
	on SoftShadowPrecisionSlider changed index do
	(
		-- Moving the slider always turns off "custom"; no official slider position for "custom"
		softShadowPrecisionPresetData.customToggle = false
		softShadowPrecisionPresetData.OnChanged index
		VFB_methods.CommitMentalRayChanges()
		UpdateUI()
	)
	on RenderBtn pressed do
	(
		try
		(
			if maxops.rendUseIterative then
			(
				actionMan.executeAction 0 "59244"  -- Render: Render Iterative
			)
			else
			(
				actionMan.executeAction 0 "59243"  -- Render: Render Production
			)
		)
		catch
		(
		)
	)
	on RenderModeDropdown selected index do
	(
		VFB_methods.HandleRenderModeDropdown selected index
	)
)


-------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------
--
-- Helper functions
--

struct VFB_ViewportInfo
(
	totalVptNum_,  -- total count of active & non-extended viewport
	entries_ -- arrary of VFB_ViewportInfoEntry
)

struct VFB_ViewportInfoEntry
(
	name_, -- name in the viewportDropdown list
	type_, -- viewport type
	index_, -- index in the viewportDropdown list
	viewId_ -- viewID of this viewport
)

struct VFB_methods_struct
(
	-------------------------------------------------------------------------------------------------
	-------------------------------------------------------------------------------------------------
	-------------------------------------------------------------------------------------------------
	--
	-- Global variables
	--
	
	-- List of information about each rollout and floater
	VFB_RolloutInfo_Array = undefined,
	VFB_Interface = undefined,

	showOverlays = undefined,
	showRollups = undefined,
	imagePrecisionPresetData = undefined,
	UnifiedPrecisionPresetData = undefined,
	finalGatherPresetData = undefined,
	glossyReflectionPrecisionPresetData = undefined,
	glossyRefractionPrecisionPresetData = undefined,	
	softShadowPrecisionPresetData = undefined,		
	viewportInfo = undefined,
	
	----------------------------------------------------------------------------
	-- LOCALIZATION [begin - translate everything section]
	-- Translate everything in quotes below

	viewportTypeTableSorted = undefined,
	viewportTypeTable =
	#(		-- Viewport Type Code		-- Dropdown name	--Table Index
			#( #view_top,				~VIEWPORTTYPETABLE_TOP~,				  1 ),
			#( #view_bottom,		~VIEWPORTTYPETABLE_BOTTOM~,		    2 ),
			#( #view_right,			~VIEWPORTTYPETABLE_RIGHT~,	      3 ),
			#( #view_left,			~VIEWPORTTYPETABLE_LEFT~,				  4 ),
			#( #view_front,			~VIEWPORTTYPETABLE_FRONT~,			  5 ),
			#( #view_back,			~VIEWPORTTYPETABLE_BACK~,				  6 ),
			#( #view_persp_user, ~VIEWPORTTYPETABLE_PERSPECTIVE~,	7 ),
			#( #view_iso_user,	~VIEWPORTTYPETABLE_ORTHOGRAPHIC~,	8 ),
			#( #view_shape,			~VIEWPORTTYPETABLE_SHAPE~,    		9 ),
			#( #view_grid,			~VIEWPORTTYPETABLE_GRID~,			    10 )
	),		

	-- LOCALIZATION [end - translate everything section]
	----------------------------------------------------------------------------
	

	function Init =
	(	
		struct VFB_RolloutInfo (rollout_,floater_,placement_,size_,renderer_ = unsupplied,rendererExcept_ = unsupplied)
		VFB_RolloutInfo_TopLeft   = VFB_RolloutInfo rollout_:VFB_Rollout_TopLeft  placement_:#TopLeft 
		VFB_RolloutInfo_TopRight  = VFB_RolloutInfo rollout_:VFB_Rollout_TopRight placement_:#TopRight rendererExcept_:mental_ray_renderer
		VFB_RolloutInfo_Bottom    = VFB_RolloutInfo rollout_:VFB_Rollout_Bottom   placement_:#Bottom renderer_:mental_ray_renderer
		VFB_RolloutInfo_Array = #( VFB_RolloutInfo_TopLeft, VFB_RolloutInfo_TopRight, VFB_RolloutInfo_Bottom ) 
		
		if viewportTypeTableSorted ==undefined do
		(
			viewportTypeTableSorted = copy viewportTypeTable #noMap
			qsort viewportTypeTableSorted VFB_methods.LookupTableComparator
		)
		
		showRollups = TRUE
		showOverlays = TRUE
	),
		
	function VFB_IsInitialized =
	(
		(VFB_Interface!=undefined) and not (isDeleted VFB_Interface) and (VFB_Interface.IsInitialized)
	),

	
	-------------------------------------------------------------------------------------------------
	-------------------------------------------------------------------------------------------------
	-------------------------------------------------------------------------------------------------
	--
	-- Helper functions
	--

	-- Compare function used by LookupTableLookup()
	function LookupTableComparator a b =
	(
		if a[1]>b[1] then 1
		else if a[1]<b[1] then -1
		else 0
	),

	-- Finds an item in a lookup table;
	-- A lookup table is a sorted array of items, where each item is an array with its key as the first entry
	function LookupTableLookup itemKey itemTable =
	(
		local lookupKey = #(itemKey)
		local lookupResult = bsearch lookupKey itemTable LookupTableComparator
		lookupResult -- Return value
	),
	
	-- Finds an item in a string table;
	-- A string table is a sorted array of items, where each item is an array with its key and the string as the first two entries
	function StringTableLookup stringKey stringTable =
	(
		local lookupResult = LookupTableLookup stringKey stringTable
		if lookupResult==undefined then undefined else lookupResult[2]
	),
	
	-- Compare two arrays, structs, or bitarrays, with support for nested types (arrays of structs etc)
	fn DeepCompare a b =
	(
		local match = true
		if (classof a) != (classof b) then match = false -- return false, not same type
		else
		(
			if (IsStruct a) then
			( -- Compare  structs
				local propNames = (GetPropNames a) -- Since b is the same class, assume same properties
				for propName in propNames while match do
				(
					match = (deepCompare (GetProperty a propName) (GetProperty b propName))
				)
			)
			else if (classof a) == Array then
			( -- Compare arrays
				local count = a.count
				if (count == b.count) then
				(
					for i = 1 to count while match do
					(
						match = (deepCompare a[i] b[i])
					)
				)
				else match = false -- return false, not same array size
			)
			else if (classof a) == bitarray then
			( -- Compare bitarrays
				match = (a.numberset == b.numberset) and ((a-b).isEmpty)
			)
			else -- Compare primitive objects
				match = (a==b)
		)
		match -- return value
	),	

	-- Gets the display name of a given viewport, which will be a node name for camera or spotlight viewports
	function GetViewportName index viewPanelIndex=
	(
		local viewportType = viewport.getType index:index viewPanelIndex:viewPanelIndex
		if (viewportType==#view_spot) or (viewportType==#view_camera) then
		(
			local viewportCamera = viewport.getCamera index:index
			if( viewportCamera==undefined ) then
				~VIEWPORT_CAMERA_VIEW_NAME~
			else
				viewportCamera.name			
		)
		else VFB_methods.StringTableLookup viewportType viewportTypeTableSorted
	),
	
	-- generate a structure with key viewports information for quick reference and comparison
	function GetViewportInfo =
	(	
		retval = VFB_ViewportInfo totalVptNum_:(0) entries_:#()
		
		local numViewports = 0
		local numViewPanels = ViewPanelManager.GetViewPanelCount()
		local viewPanelName = undefined
		local listCount = 1 -- dropdownList is 1-based index
		for j = 1 to numViewPanels do
		(
			viewPanelName = ViewPanelManager.GetViewPanelName j
			numViewports = viewport.numViewEx viewPanelIndex:j
			for i = 1 to numViewports do
			(
				local vptName = VFB_Methods.GetViewportName i j
				local listName = viewPanelName + " - " + vptName
				local viewportType = (viewport.GetType index:i viewPanelIndex:j)
				local vptID = viewport.GetID i viewPanelIndex: j
				entry = VFB_ViewportInfoEntry name_:listName type_:viewportType index_:listCount viewId_: vptID
				append retval.entries_ entry
				listCount = listCount + 1
			)
		)
		
		retval.totalVptNum_ = listCount - 1
		retval
	),
	
	function CompareViewportInfo viewportInfoA viewportInfoB =
	(
		deepCompare viewportInfoA viewportInfoB
	),
	
	function GetRolloutSize rolloutParam =
	(
		[ rolloutParam.width, rolloutParam.height ] -- return value
	),
	
	-- Updates the render dialog (if open) to show any render settings changed in maxscript
	function CommitRenderChanges =
	(
		if renderSceneDialog.isOpen() do
		(
			renderSceneDialog.Update()
		)
		-- Mark the scene as dirty.
		setSaveRequired true
	),
	-- Updates the mental ray tabs of the render dialog (if open) to show any render settings changed in maxscript
	function CommitMentalRayChanges =
	(
		local curRenderer = renderers.current
		if (classof curRenderer) == mental_ray_renderer do
		(
			curRenderer.UpdateUI()
		)
		-- Mark the scene as dirty.
		setSaveRequired true
	),
	
	-------------------------------------------------------------------------------------------------
	-- RemoveRollouts

	function VFB_RemoveRollouts =
	(
		if VFB_IsInitialized() do
		(
			-- For each rollout in our list
			for item in VFB_RolloutInfo_Array do
			(
				if (item!=undefined) and (item.rollout_!=undefined) and (item.floater_!=undefined) do
				(
					VFB_Interface.SetRolloutWindowVisible item.placement_ false
					removeRollout item.rollout_ item.floater_
				)
			)
		)
	),

	-------------------------------------------------------------------------------------------------
	-- AddRollouts

	function VFB_AddRollouts param =
	(
		if param.isFramebuffer do
		(
			VFB_Interface = param
			
			if VFB_IsInitialized() do
			(
				-- Set layout metrics
				VFB_Interface.SetMetric #horzMarginLeft		0
				VFB_Interface.SetMetric #horzMarginCenter	0
				VFB_Interface.SetMetric #horzMarginRight	0
				VFB_Interface.SetMetric #vertMarginTop		0
				VFB_Interface.SetMetric #vertMarginCenter	0
				VFB_Interface.SetMetric #vertMarginBottom	0
				VFB_Interface.SetMetric #minClientWidth		0
				VFB_Interface.SetMetric #minClientHeight	0
				VFB_Interface.showRollups = showRollups
				VFB_Interface.showOverlays = showOverlays
				local padWidth = 2 -- For future tweaking, currently has no effect
				local padHeight = 4
				
				
				-- For each rollout in our list
				for item in VFB_RolloutInfo_Array do
				(
					-- Check whether the rollout requires a specific renderer
					if (    ((item.renderer_==unsupplied) and ((classof renderers.current) !=item.rendererExcept_)) \ --this rollout will appear except the current renderer is the specific renderer
						or (((classof renderers.current) == item.renderer_) and (item.rendererExcept_ == unsupplied)) \ -- this roll out will appear only if the current renderer is the specific renderer
						or ( (item.renderer_==unsupplied) and (item.rendererExcept_ == unsupplied) ) \ -- if both values are not specified, it will always.appear 
						) do
					(
						-- Initialize the rollout default size.
						-- Note that the width/height of a rollout changes when it is added to a rolloutWindow.
						-- So we must get the "original size" only once, before the rollout is first added.
						-- Also, without padding by 8, rollouts are cropped on right and bottom. I don't know why.
						if item.size_==undefined do item.size_ = ((GetRolloutSize item.rollout_) + [padWidth,padHeight])
						
						item.floater_ = VFB_Interface.InitRolloutWindow item.placement_ item.size_.x item.size_.y
						addRollout item.rollout_ item.floater_ border:false
						VFB_Interface.SetRolloutWindowVisible item.placement_ true
					)
				)
			)
		)
	),

	-------------------------------------------------------------------------------------------------
	-- ResetRollouts

	function VFB_ResetRollouts =
	(	
		-- Check whether the VFB is open...
		-- Interface is undefined if VFB has never been opened yet. Otherwise...
		-- Interface is a deleted interface whenever it's closed
		if VFB_IsInitialized() do
		(
			VFB_RemoveRollouts()
			VFB_AddRollouts VFB_Interface
			VFB_Interface.InitLayout()
		)
	),

	-------------------------------------------------------------------------------------------------
	-- Reset

	function Reset =
	(	-- Called on file open, new and reset
		VFB_methods.imagePrecisionPresetData = undefined
		VFB_methods.UnifiedPrecisionPresetData = undefined
		VFB_methods.finalGatherPresetData = undefined
		VFB_methods.glossyReflectionPrecisionPresetData = undefined
		VFB_methods.glossyRefractionPrecisionPresetData = undefined
		VFB_methods.softShadowPrecisionPresetData = undefined	
		VFB_methods.VFB_ResetRollouts() -- VFB can remain open during file open, new and reset.  If it does, reset the rollouts
	),
	
	function HandleRenderModeDropdown selected index =
	(
		-- JOHNSON RELEASE SDK
		--rendUseIterative = (if (index==1) then true else false)
		-- JOHNSON PRE-RELEASE SDK
        maxops.rendUseIterative = (if (index==1) then true else false)
		VFB_methods.CommitRenderChanges()
	)

	
) -- struct VFB_methods_struct


if VFB_methods==undefined then
(
	VFB_methods = VFB_methods_struct()
	VFB_methods.Init()
)
else VFB_methods_struct.Reset()

-------------------------------------------------------------------------------------------------
-- Callbacks
-- Starting point, detects when the VFB is displayed or the renderer is changed, and installs rollouts

callbacks.removeScripts #postRendererChange id:#vfb_rollouts
callbacks.addScript #postRendererChange "VFB_methods.VFB_ResetRollouts()" id:#VFB_Rollouts

callbacks.removeScripts #preImageViewerDisplay id:#VFB_Rollouts
callbacks.addScript #preImageViewerDisplay "VFB_methods.VFB_AddRollouts (callbacks.notificationParam())" id:#VFB_Rollouts

callbacks.removeScripts #filePostOpen id:#VFB_Rollouts -- Reset after a file is opened, but ignore Render Preset loading (when param equals 2)
callbacks.addScript #filePostOpen "if (callbacks.notificationParam() !=2)  do VFB_methods_struct.Reset()" id:#VFB_Rollouts
callbacks.removeScripts #systemPostReset id:#VFB_Rollouts
callbacks.addScript #systemPostReset "VFB_methods_struct.Reset()" id:#VFB_Rollouts
callbacks.removeScripts #systemPostNew id:#VFB_Rollouts
callbacks.addScript #systemPostNew "VFB_methods_struct.Reset()" id:#VFB_Rollouts


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCqLa1cLFmPqE7/s90OSnR/osoyqi6JV5gD
-- g4DSluCHM4Dq4voWJzADvXB3Rlq23bP2cGsNsGU2OZKmPj0Vlax3mmvAoNztzvTb
-- b/aFSnOpcPZoFGcivE0HL/Yld1P+NGh63i/nE+BWaAIEAJgCJXvb0R51e49Sf/2X
-- /wd8bJXswXV6ACOm9y/2PN1PWVf5jtYV+OXjKK9EUOLF8N6MZpLtbQmHBpCI4Jgi
-- EFU7ocWkB6rpzHJPWh8yWJ7k+tCzU92oAFIC/PVrjycT8GPRrbrhJ641dAFbTLju
-- iLwjxpB2zVCyV0XKhd5/EoXKUjJaqh8pXTlDe2RqIYcZBEjOyecj
-- -----END-SIGNATURE-----